/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.LinkedList;

public class GUIStringUtilities {
    private GUIStringUtilities() {
    }

    public static String abbreviate(String longName) {
        if (longName == null) {
            return "<Unnamed>";
        }
        if (longName.length() < 80) {
            return longName;
        }
        return longName.substring(0, 37) + ". . ." + longName.substring(longName.length() - 38);
    }

    public static String split(String longName) {
        if (longName == null) {
            return "<Unnamed>";
        }
        if (longName.length() < 80) {
            return longName;
        }
        StringBuffer results = new StringBuffer();
        int i = 0;
        while (i < longName.length() - 80) {
            results.append(longName.substring(i, i + 79) + "\n");
            i += 80;
        }
        results.append(longName.substring(i));
        return results.toString();
    }

    public static String[] tokenizeForExec(String inputString) throws IOException {
        LinkedList<String> commandList = new LinkedList<String>();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(inputString));
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 127);
        streamTokenizer.ordinaryChar(34);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        String token = "";
        String singleToken = "";
        boolean inDoubleQuotedString = false;
        block6: while (streamTokenizer.nextToken() != -1) {
            switch (streamTokenizer.ttype) {
                case -3: {
                    if (inDoubleQuotedString) {
                        if (token.length() > 0) {
                            token = token + " ";
                        }
                        token = token + singleToken + streamTokenizer.sval;
                    } else {
                        token = singleToken + streamTokenizer.sval;
                        commandList.add(token);
                    }
                    singleToken = "";
                    break;
                }
                case -2: {
                    throw new RuntimeException("Internal error: Found TT_NUMBER: '" + streamTokenizer.nval + "'.  We should not be " + "tokenizing numbers");
                }
                case 10: {
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    singleToken = new Character((char)streamTokenizer.ttype).toString();
                    if (!singleToken.equals("\"")) continue block6;
                    if (inDoubleQuotedString) {
                        commandList.add(token);
                    }
                    inDoubleQuotedString = !inDoubleQuotedString;
                    singleToken = "";
                    token = "";
                }
            }
        }
        return commandList.toArray(new String[commandList.size()]);
    }
}

