/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import ptolemy.gui.GUIStringUtilities;
import ptolemy.gui.SwingWorker;

public class JTextAreaExec
extends JPanel {
    private ActionListener _clearListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            Runnable doAppendJTextArea = new Runnable(this){
                private final /* synthetic */ 5 this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    JTextAreaExec.access$000(5.access$200(this.this$1)).setText(null);
                }
            };
            SwingUtilities.invokeLater(doAppendJTextArea);
        }

        static /* synthetic */ JTextAreaExec access$200(5 x0) {
            return x0.JTextAreaExec.this;
        }
    };
    private ActionListener _interruptListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            JTextAreaExec.this._cancelButton.setEnabled(false);
            JTextAreaExec.this.appendJTextArea("Cancel button was pressed");
            JTextAreaExec.this._worker.interrupt();
            JTextAreaExec.this._process.destroy();
            JTextAreaExec.this._enableStartButton();
        }
    };
    private ActionListener _startListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            JTextAreaExec.this._startButton.setEnabled(false);
            JTextAreaExec.this._cancelButton.setEnabled(true);
            JTextAreaExec.this._statusBar.setText("Working...");
            JTextAreaExec.this._worker = new SwingWorker(this){
                private final /* synthetic */ 8 this$1;
                {
                    this.this$1 = this$1;
                }

                public Object construct() {
                    return JTextAreaExec.access$900(8.access$800(this.this$1));
                }

                public void finished() {
                    JTextAreaExec.access$600(8.access$800(this.this$1));
                    JTextAreaExec.access$300(8.access$800(this.this$1)).setEnabled(false);
                    JTextAreaExec.access$1000(8.access$800(this.this$1), 0);
                    JTextAreaExec.access$100(8.access$800(this.this$1)).setText(this.get().toString());
                }
            };
            JTextAreaExec.this._worker.start();
        }

        static /* synthetic */ JTextAreaExec access$800(8 x0) {
            return x0.JTextAreaExec.this;
        }
    };
    private JButton _cancelButton;
    private JButton _clearButton;
    private List _commands = null;
    private JTextArea _jTextArea;
    private Process _process;
    private JProgressBar _progressBar;
    private JLabel _statusBar;
    private JButton _startButton;
    private SwingWorker _worker;

    public JTextAreaExec(String name, boolean showButtons) {
        this.setLayout(new BoxLayout(this, 1));
        this._jTextArea = new JTextArea("", 20, 100);
        this._jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this._jTextArea);
        this.add(jScrollPane);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), name));
        this._progressBar = new JProgressBar();
        this._startButton = new JButton("Start");
        this._startButton.addActionListener(this._startListener);
        this._enableStartButton();
        this._cancelButton = new JButton("Cancel");
        this._cancelButton.addActionListener(this._interruptListener);
        this._cancelButton.setEnabled(false);
        this._clearButton = new JButton("Clear");
        this._clearButton.addActionListener(this._clearListener);
        this._clearButton.setEnabled(true);
        Border spaceBelow = BorderFactory.createEmptyBorder(0, 0, 5, 0);
        if (showButtons) {
            JPanel buttonBox = new JPanel();
            buttonBox.add(this._startButton);
            buttonBox.add(this._cancelButton);
            buttonBox.add(this._clearButton);
            this.setLayout(new BoxLayout(this, 1));
            this.add(buttonBox);
            buttonBox.setBorder(spaceBelow);
            this._statusBar = new JLabel("Click Start to begin", 0);
        } else {
            this._statusBar = new JLabel("", 0);
        }
        this.add(this._progressBar);
        this.add(this._statusBar);
        this._statusBar.setAlignmentX(0.5f);
        Border progressBarBorder = this._progressBar.getBorder();
        this._progressBar.setBorder(BorderFactory.createCompoundBorder(spaceBelow, progressBarBorder));
    }

    public void appendJTextArea(final String text) {
        Runnable doAppendJTextArea = new Runnable(){

            public void run() {
                JTextAreaExec.this._jTextArea.append(text + '\n');
                JTextAreaExec.this._jTextArea.setCaretPosition(JTextAreaExec.this._jTextArea.getText().length());
            }
        };
        SwingUtilities.invokeLater(doAppendJTextArea);
    }

    public void cancel() {
        this._cancelButton.doClick();
    }

    public void clear() {
        this._clearButton.doClick();
        this.updateStatusBar("");
        this._updateProgressBar(0);
    }

    public static void main(String[] args) {
        JFrame jFrame = new JFrame("JTextAreaExec Example");
        WindowAdapter windowListener = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        jFrame.addWindowListener(windowListener);
        LinkedList<String> execCommands = new LinkedList<String>();
        execCommands.add("date");
        execCommands.add("sleep 5");
        execCommands.add("date");
        execCommands.add("javac");
        final JTextAreaExec exec = new JTextAreaExec("JTextAreaExec Tester", true);
        exec.setCommands(execCommands);
        jFrame.getContentPane().add(exec);
        jFrame.pack();
        jFrame.show();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                exec.getStartButton().requestFocus();
                exec.start();
            }
        });
    }

    public JButton getStartButton() {
        return this._startButton;
    }

    public void setCommands(List commands) {
        this._commands = commands;
        this._enableStartButton();
    }

    public void start() {
        this._startButton.doClick();
    }

    public void updateStatusBar(final String text) {
        Runnable doUpdateStatusBar = new Runnable(){

            public void run() {
                JTextAreaExec.this._statusBar.setText(text);
                JTextAreaExec.this._jTextArea.append(text + '\n');
            }
        };
        SwingUtilities.invokeLater(doUpdateStatusBar);
    }

    private void _enableStartButton() {
        if (this._commands != null && this._commands.size() > 0) {
            this._startButton.setEnabled(true);
        } else {
            this._startButton.setEnabled(false);
        }
    }

    private Object _executeCommands() {
        try {
            Runtime runtime = Runtime.getRuntime();
            try {
                if (this._process != null) {
                    this._process.destroy();
                }
                this._progressBar.setMaximum(this._commands.size());
                int commandCount = 0;
                Iterator commands = this._commands.iterator();
                while (commands.hasNext()) {
                    this._updateProgressBar(++commandCount);
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    String[] commandTokens = GUIStringUtilities.tokenizeForExec((String)commands.next());
                    this.appendJTextArea("About to execute:\n");
                    StringBuffer statusCommand = new StringBuffer();
                    int i = 0;
                    while (i < commandTokens.length) {
                        this.appendJTextArea("\t" + commandTokens[i]);
                        if (statusCommand.length() < 50) {
                            if (statusCommand.length() > 0) {
                                statusCommand.append(" ");
                            }
                            statusCommand.append(commandTokens[i]);
                        }
                        ++i;
                    }
                    if (statusCommand.length() >= 50) {
                        statusCommand.append(" . . .");
                    }
                    this._statusBar.setText("Executing: " + statusCommand.toString());
                    this._process = runtime.exec(commandTokens);
                    _StreamReaderThread errorGobbler = new _StreamReaderThread(this._process.getErrorStream(), "ERROR", this);
                    _StreamReaderThread outputGobbler = new _StreamReaderThread(this._process.getInputStream(), "OUTPUT", this);
                    errorGobbler.start();
                    outputGobbler.start();
                    try {
                        int processReturnCode = this._process.waitFor();
                        JTextAreaExec jTextAreaExec = this;
                        synchronized (jTextAreaExec) {
                            this._process = null;
                        }
                        if (processReturnCode == 0) continue;
                        break;
                    }
                    catch (InterruptedException interrupted) {
                        this.appendJTextArea("InterruptedException: " + interrupted);
                        throw interrupted;
                    }
                }
                this.appendJTextArea("All Done.");
            }
            catch (IOException io) {
                this.appendJTextArea("IOException: " + io);
            }
        }
        catch (InterruptedException e) {
            this._process.destroy();
            this._updateProgressBar(0);
            return "Interrupted";
        }
        return "All Done";
    }

    private void _updateProgressBar(final int i) {
        Runnable doSetProgressBarValue = new Runnable(){

            public void run() {
                JTextAreaExec.this._progressBar.setValue(i);
            }
        };
        SwingUtilities.invokeLater(doSetProgressBarValue);
    }

    static /* synthetic */ Object access$900(JTextAreaExec x0) {
        return x0._executeCommands();
    }

    static /* synthetic */ void access$1000(JTextAreaExec x0, int x1) {
        x0._updateProgressBar(x1);
    }

    private class _StreamReaderThread
    extends Thread {
        private InputStream _inputStream;
        private String _streamType;
        private JTextAreaExec _jTextAreaExec;

        _StreamReaderThread(InputStream inputStream, String streamType, JTextAreaExec jTextAreaExec) {
            this._inputStream = inputStream;
            this._streamType = streamType;
            this._jTextAreaExec = jTextAreaExec;
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this._inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    this._jTextAreaExec.appendJTextArea(line);
                }
            }
            catch (IOException ioe) {
                this._jTextAreaExec.appendJTextArea("IOException: " + ioe);
            }
        }
    }
}

