/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.ListIterator;
import ptolemy.plot.PlotBox;

public class Render
extends PlotBox {
    private int[][] _colormap = new int[3][256];
    private static final int _HIGHCOLOR = 225;
    private LinkedList _imageData = new LinkedList();
    private static final int _LOWCOLOR = 175;
    private static final int _NOTVISIBLE = -999;
    private boolean _showing = false;
    private double _xIncrement = 0.0;
    private double _xOffset = 0.0;
    private double _yIncrement = 0.0;
    private double _yOffset = 0.0;

    public Render() {
        this.setGrid(false);
        this._setPadding(0.0);
        int[] rgb = new int[256];
        int i = 0;
        while (i <= 255) {
            rgb[i] = i;
            ++i;
        }
        this._colormap[0] = rgb;
        this._colormap[1] = rgb;
        this._colormap[2] = rgb;
    }

    public synchronized void addStripe(int[] colors) {
        int[] newStripe = new int[colors.length];
        System.arraycopy(colors, 0, newStripe, 0, newStripe.length);
        this._imageData.add(newStripe);
        this._xTop = (double)this._imageData.size() * this.getXIncrement();
        this._xBottom = this.getXOffset();
        this._yTop = (double)((int[])this._imageData.getFirst()).length * this.getYIncrement();
        this._yBottom = this.getYOffset();
        this.setXRange(this.getXOffset(), (double)this._imageData.size() * this.getXIncrement());
        this.setYRange(this.getYOffset(), (double)((int[])this._imageData.getFirst()).length * this.getYIncrement());
    }

    public synchronized void clearData() {
        this._imageData = new LinkedList();
    }

    public synchronized int[][] getColormap() {
        return this._colormap;
    }

    public synchronized double getXIncrement() {
        return this._xIncrement;
    }

    public synchronized double getXOffset() {
        return this._xOffset;
    }

    public synchronized double getYIncrement() {
        return this._yIncrement;
    }

    public synchronized double getYOffset() {
        return this._yOffset;
    }

    public synchronized void samplePlot() {
        Runnable sample = new Runnable(){

            public void run() {
                Render render = Render.this;
                synchronized (render) {
                    Render.this.clear(true);
                    Render.this.setGrid(false);
                    Render.this.setTitle("Sample image");
                    Render.this.setYLabel("hertz");
                    Render.this.setXLabel("time");
                    Render.this.setXIncrement(0.05);
                    Render.this.setXOffset(0.0);
                    Render.this.setYIncrement(40.0);
                    Render.this.setYOffset(0.0);
                    int[] stripe1 = new int[100];
                    int colorValue = 225;
                    int i = 0;
                    while (i < stripe1.length) {
                        stripe1[i] = colorValue;
                        colorValue = colorValue == 175 ? 225 : 175;
                        ++i;
                    }
                    int[] stripe2 = new int[100];
                    System.arraycopy(stripe1, 0, stripe2, 1, stripe2.length - 1);
                    stripe2[0] = 175;
                    Render.this.clearData();
                    int i2 = 1;
                    while (i2 <= 50) {
                        Render.this.addStripe(stripe1);
                        Render.this.addStripe(stripe2);
                        ++i2;
                    }
                }
            }
        };
        this.deferIfNecessary(sample);
        this.repaint();
    }

    public synchronized void setColormap(int[][] colormap) {
        this._colormap = colormap;
    }

    public synchronized void setXIncrement(double xIncrement) {
        this._xIncrement = xIncrement;
    }

    public synchronized void setXOffset(double xOffset) {
        this._xOffset = xOffset;
    }

    public synchronized void setYIncrement(double yIncrement) {
        this._yIncrement = yIncrement;
    }

    public synchronized void setYOffset(double yOffset) {
        this._yOffset = yOffset;
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean clearfirst) {
        super._drawPlot(graphics, clearfirst);
        double x1 = (double)this._ulx + (this._originalXlow - this._xMin) * this._xscale + 1.0;
        double width = this._xIncrement * this._xscale;
        double x2 = x1 + width;
        ListIterator imageDataIterator = this._imageData.listIterator(0);
        while (imageDataIterator.hasNext()) {
            int[] currentStripe = (int[])imageDataIterator.next();
            this._drawStripe(graphics, currentStripe, x1, (int)x2 - (int)x1);
            x1 = x2;
            x2 = x1 + width;
        }
        this._showing = true;
    }

    private int[] _clipXWidth(int x, int width) {
        int[] returnArray = new int[2];
        if (x < this._ulx + 1 && x + width > this._lrx - 1) {
            returnArray[0] = this._ulx + 1;
            returnArray[1] = this._lrx - this._ulx - 1;
        } else if (x < this._ulx + 1 && x + width > this._ulx + 1) {
            returnArray[0] = this._ulx + 1;
            returnArray[1] = width - (this._ulx - x);
        } else if (x >= this._ulx + 1 && x + width <= this._lrx - 1) {
            returnArray[0] = x;
            returnArray[1] = width;
        } else if (x <= this._lrx - 1 && x + width > this._lrx - 1) {
            returnArray[0] = x;
            returnArray[1] = this._lrx - x;
        } else {
            returnArray[0] = -999;
        }
        return returnArray;
    }

    private int[] _clipYHeight(int y, int height) {
        int[] returnArray = new int[2];
        if (y < this._uly + 1 && y + height > this._lry - 1) {
            returnArray[0] = this._uly + 1;
            returnArray[1] = this._lry - this._uly - 1;
        } else if (y < this._uly + 1 && y + height >= this._uly + 1) {
            returnArray[0] = this._uly + 1;
            returnArray[1] = height - (this._uly - y);
        } else if (y >= this._uly + 1 && y + height <= this._lry - 1) {
            returnArray[0] = y;
            returnArray[1] = height;
        } else if (y <= this._lry - 1 && y + height > this._lry - 1) {
            returnArray[0] = y;
            returnArray[1] = this._lry - y;
        } else {
            returnArray[0] = -999;
        }
        return returnArray;
    }

    private void _drawStripe(Graphics graphics, int[] stripe, double x, double width) {
        if (width < 1.0) {
            width = 1.0;
        }
        double y1 = (double)(this._lry - (int)((this._originalYhigh - this._yMin) * this._yscale)) + 1.0;
        double height = this._yIncrement * this._yscale;
        double y2 = y1 + height;
        int i = 0;
        while (i < stripe.length) {
            this._drawPatch(graphics, (int)x, (int)y1, (int)width, (int)y2 - (int)y1, stripe[i]);
            y1 = y2;
            y2 = y1 + height;
            ++i;
        }
    }

    private void _drawPatch(Graphics graphics, int x, int y, int width, int height, int colorValue) {
        if (height < 1) {
            height = 1;
        }
        int r = this._colormap[0][colorValue];
        int g = this._colormap[1][colorValue];
        int b = this._colormap[2][colorValue];
        graphics.setColor(new Color(r, g, b));
        int[] xAndWidth = this._clipXWidth(x, width);
        x = xAndWidth[0];
        width = xAndWidth[1];
        if (x == -999) {
            return;
        }
        int[] yAndHeight = this._clipYHeight(y, height);
        y = yAndHeight[0];
        height = yAndHeight[1];
        if (y == -999) {
            return;
        }
        graphics.fillRect(x, y, width, height);
    }
}

