/* Demo for a live signal plotter.

@Copyright (c) 1997-2002 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the
above copyright notice and the following two paragraphs appear in all
copies of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.

                                                PT_COPYRIGHT_VERSION_2
                                                COPYRIGHTENDKEY
@ProposedRating red (eal@eecs.berkeley.edu)
@AcceptedRating red (cxh@eecs.berkeley.edu)
*/


import ptolemy.plot.PlotLive;

import java.awt.Event;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

import java.io.*;
import java.net.*;


//////////////////////////////////////////////////////////////////////////
//// PlotLiveDemo
/**
Dynamically plot a test signal, illustrating how to use the
PlotLive class.

@author Edward A. Lee
@version $Id: PlotLiveDemo.java,v 1.48.2.2 2002/06/14 17:26:25 cxh Exp $
@since Ptolemy II 0.2
*/
public class PlotLiveDemo extends PlotLive {

    /** Construct a plot for live, animated signal display.
     *  Configure the title, axes, points style, and persistence.
     */
    StringBuffer buf;
    
    String[] line = new String[11];
    URL url=null;
    
    double[] x = new double[10];
    double[] y = new double[10];
    
    double tempX1 = 0;
    double tempY1 = 0;
    
    double tempX2 = 0;
    double tempY2 = 0;
    
    int MAX_X = 800;
    
    int xupper = MAX_X;
    int xlower = -1;
    
    public PlotLiveDemo() {
        setYRange(-180, 180);
        setXRange(-1, MAX_X);
        //setPointsPersistence(300);
        //setMarksStyle("points");
        setMarksStyle("none");
        clear(0);
        //setConnected(false);
        // setImpulses(true);
    }

    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /** Add points to the plot.  This is called by the base class
     *  run() method when the plot is live.
     */
    public synchronized void addPoints() {
        // You could plot multiple points at a time here
        // for faster response, but in our case, we really need
        // to slow down the response for visual aesthetics.
     
       try {
            BufferedReader in = new BufferedReader(new FileReader("c:\\plot.txt"));
            
            for (int i = 0; i<11; i++) {
                line[i] = in.readLine();
            }
            in.close();
       }catch (IOException e) {System.out.println("READ FAILED");}
        
       x[0] = 10.0*(Double.parseDouble(line[0]));
       for (int i = 1; i<10; i++) {
           x[i] = x[i-1]+1;
       }
       
       for (int i = 0; i<10; i++) {
           y[i] = Double.parseDouble(line[i+1]);
       }
       
       
       if ((x[9] == xupper)) {
            xupper+=1;
            xlower+=1;
            
            setXRange(xlower, xupper);
            repaint();        
       } else if ((x[9]> xupper)&(x[9] <= (xupper+500))) {
            double temp_A = x[9]-xupper;
            xupper += temp_A;
            xlower += temp_A;
            setXRange(xlower, xupper);
            repaint();             
        }
        
        if (x[0] < xupper+1000) {
            if ((y[0] >= -180.0)&(y[0] <= 180)&(y[9] >=-180.0)&(y[9] <= 180)) {
                for (int i = 0; i<10; i++) {
                    addPoint(0, x[i], y[i], true);    
                }
                setXRange(xlower, xupper);
                repaint();
            };
            
            if (x[0] == 10) {
                clear(0);
                int xupper = MAX_X;
                xlower = -1;
                setXRange(xlower, xupper);
                for (int i = 0; i<10; i++) {
                    addPoint(0, x[i], y[i], true);    
                }
                repaint();
            }
         
         };
        
        try {
            Thread.sleep(5);
        } catch (InterruptedException e) {}
    }

    /** Run the demo as an application.
     *        This is very useful for debugging.  The command to run would be
     * java -classpath $PTII ptolemy.plot.demo.PlotLiveDemo
     */
    public static void main(String args[]) {
        final PlotLiveDemo plotLiveDemo = new PlotLiveDemo();
        System.runFinalizersOnExit(true);
        JFrame frame = new JFrame("PlotLiveDemo");
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent event) {
                plotLiveDemo.stop();
                System.exit(0);
            }
        });
        frame.getContentPane().add("Center", plotLiveDemo);
        frame.show();
        plotLiveDemo.setButtons(true);
        plotLiveDemo.start();
        frame.pack();
    }



    ///////////////////////////////////////////////////////////////////
    ////                         private variables                 ////

    /** @serial Value being plotted */
    private double _count = 0.0;
}
