import java.awt.*;

/*
 *
 * NumberTextField.java
 * Customised AWT component 
 * Demonstration for Java 107 tutorial
 * David Reilly, 21 February, 1998
 *
 */	

public class NumberTextField extends TextField
{	
	public NumberTextField(int cols)
	{
		super (cols);
	}

	public boolean keyDown(Event evt, int key)
	{
		// Cast to a character
		char keyChar = (char) key;

		// Accept 0-9, . -, backspace or delete
		if ( (keyChar == '0') || (keyChar == '1') || (keyChar == '2') ||
			 (keyChar == '3') || (keyChar == '4') || (keyChar == '5') || 
                         (keyChar == '6') || (keyChar == '7') || (keyChar == '8') ||
                         (keyChar == '9') || (keyChar == 8) || (keyChar == 127) ||
				 (keyChar == '.') || (keyChar == '-') )
		{			
			// Pass along to our superclass
			return super.keyDown(evt, key);
		}
		else
			// Yes we've handled it... by ignoring invalid data
			return true;

	}
}

