//package DC_motor_Client.src;

import java.io.*;
import java.net.*;

class Network_Thread extends Thread {
    static final int ECHO_PORT = 7;

    String  serverName      = "128.238.129.111";
    
    short command          = 0;
    short kp               = 500;
    short kd               = -400;
    
    byte[] spidata = new byte[2];
    int ADC_bytecode;
    float[] voltage = new float[11];
    
    byte[] send = new byte[6];
    byte[] temp = new byte[2];
    
    int j = 0;
    int k = 0;
    
    String L1 = "0";
    String L2 = "0.5";
    String L3 = "-0.4";
    BufferedReader sys_param;
    PrintWriter out_data;
    
    
    /** Constructor**/
    //public Network_Thread(short command, float kp, float kd) {    
    public Network_Thread(String L1, String L2, String L3) {    
        this.L1 = L1;
        this.L2 = L2;
        this.L3 = L3;
        grab_parameters();
    }
    
    public void grab_parameters() {
        
        if (L1 == null) { this.command = 0;} 
        else { this.command = (short)(Double.parseDouble(L1)); }
        
        if (L2 == null) { this.kp = 500; }
        else { this.kp = (short)(1000.0*Double.parseDouble(L2)); }
        
        if (L3 == null) {this.kd = -400; }
        else { this.kd = (short)(1000.0*Double.parseDouble(L3)); }
    }
    
    
    public void save_data() {
        try {
            this.out_data = new PrintWriter(new BufferedWriter(new FileWriter("c:\\plot.txt")));
            
            for (this.k = 0; this.k < 11; this.k++) {
                this.out_data.println(Double.toString((double)this.voltage[this.k]));
            }            
            this.out_data.close();
        } catch (IOException e) {System.out.println("WRITE FAILED");}
    }
    
    float Convert_AtoD(int value) {
        if ((value >= 0)&(value <= 2048)) {
            return (float)(5.0*(value/2048.0));
        } else{
            return (float)(5.0*((value - 4096)/2048.0));
        }        
    }
    
    byte[] ShortToByteArray(short value) {
        byte[] N = new byte[2];
        N[0] = (byte)((value & 0xFF00)>>>8);
        N[1] = (byte)((value & 0x00FF));        
        return N;
    }
    
    short ByteArrayToShort(byte[] N) {
        short value = (short)(((N[0]<<8)&0xFF00) | (N[1]&0x00FF));
        return value;        
    }
    
    void BuildByteArray() {
        this.temp = ShortToByteArray(this.command);
        this.send[0] = (byte)this.temp[0];
        this.send[1] = (byte)this.temp[1];
        
        this.temp = ShortToByteArray(this.kp);
        this.send[2] = (byte)this.temp[0];
        this.send[3] = (byte)this.temp[1];
        
        this.temp = ShortToByteArray(this.kd);
        this.send[4] = (byte)this.temp[0];
        this.send[5] = (byte)this.temp[1];
    }
    
    public void decode_and_save(byte[] b) {
        this.spidata[0] = b[0];
        this.spidata[1] = b[1];
        voltage[0] = (float)ByteArrayToShort(this.spidata);
        
        for (this.j = 1; this.j < 11; this.j++) {
            this.spidata[0] = b[(2*this.j)];
            this.spidata[1] = b[(2*this.j)+1];
        
            this.ADC_bytecode = (((spidata[0]&0x7F)<<5)|((spidata[1]&0xFC)>>>2));    // Converts the 2 bytes into an integer value
            this.voltage[this.j] = (float)(36.6693*Convert_AtoD(ADC_bytecode));
        }
        System.out.println(voltage[0]);
        //System.out.println(36.6693*voltage[1]);
    }
    
    
    /** Send out the bytes and print the return data. */
    public void run() {    
        Socket s = null;
        
        byte[] send_ByteArray = new byte[6];
        //BuildByteArray();
        
        try {
            s = new Socket(InetAddress.getByName(serverName), ECHO_PORT);
      
            InputStream   in  = s.getInputStream();
            OutputStream  out = s.getOutputStream();
      
            byte[] b = new byte[22];
            
            //b[0] = this.characterToSend;

            // Main for loop that writes and reads from Socket
            //for(int i = 0; i < 100; i++) {
            while (true) {
                BuildByteArray();
                out.write(this.send);
                in.read(b);
                decode_and_save(b); 
                save_data();
                grab_parameters();
            }
        } catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
        finally {            
            try {
                s.close();
            } catch (IOException e) {  
                System.out.println(e);
                e.printStackTrace();
            }
        }
    }
} // end of class
