import java.io.*;


class DC_motor {

    private SPI spi_LTC;
    private SPI spi_MAX;
    
    public short command;
    public float kp;
    public float kd;
    int N;
    
    float[] sys_out = new float[2];
    byte[] pot_bytes = new byte[20];
    
    byte[] spidata = new byte[3];
    byte[] spidata_DAC = new byte[2];
    
    int ADC_bytecode = 0;
    
    int temp_int = 0;
    byte[] temp_byte_array = new byte[2];
    
    int i = 0;
    
    /* DC_motor Constructor */
    public DC_motor(short command, float kp, float kd, int N) {
        this.command = command;
        this.kp = kp;
        this.kd = kd;
        this.N = N;
        this.sys_out[0] = (float)0.0;
        this.sys_out[1] = (float)0.0;
        
        // Create SPI object for communication with A to D and D to A
        // The interupts are disabled during SPI communication
        spi_LTC = new SPI(0, true, true, false, false, false);
        spi_MAX = new SPI(0, true, true, false, false, false);
    }
    
    /* Converts a bytecode from ADC to a float voltage value */
    float Convert_AtoD() {
        if ((this.ADC_bytecode >= 0)&(this.ADC_bytecode <= 2048)) {
            return (float)(5.0*(this.ADC_bytecode/2048.0));
        } else{
            return (float)(5.0*((this.ADC_bytecode - 4096)/2048.0));
        }
    }
    
    /* Converts a voltage from DAC to a byte array */
    byte[] Convert_DtoA(float voltage, boolean motor_or_PM) {      
        if ((voltage <= 4.8)&(voltage >= 0.0)) {
            this.temp_int = (int)((voltage/5.0)*2048.0 + 2048.0);
        } else if ((voltage >= -4.8)&(voltage <= -0.0)) {
            this.temp_int = (int)((voltage/5.0)*2048.0 + 2048.0);
        } else if (voltage > 4.8) {
            this.temp_int = 4000;       // +5 VDC saturation constraint
        } else {
            this.temp_int = 10;          // -5 VDC saturation constraint
        }      
        
        this.temp_byte_array[1] = (byte)(this.temp_int & 0x00FF);       
        
        if (motor_or_PM) {
        	this.temp_byte_array[0] = (byte)(((byte)(this.temp_int>>>8))| 0x30);
        } else {
        	this.temp_byte_array[0] = (byte)(((byte)(this.temp_int>>>8))| 0x70);
        }

        return this.temp_byte_array;        
    }
    
    /* Gets ADC bytecode and converts to float voltage value */
    public void ADC_get() {
        // First obtain potentiometer data
        this.spidata[0] = (byte)0x81;
        this.spidata[1] = (byte)0x00;
        this.spidata[2] = (byte)0x00;
        
        // Transmits ADC command and receives data into spidata[1] and spidata[2]
        spi_LTC.xmit(this.spidata, 0, this.spidata.length);   
        
        // Converts the 2 bytes into an integer value
        this.ADC_bytecode = (((this.spidata[1]&0x7F)<<5)|((this.spidata[2]&0xFC)>>>2));    
        this.sys_out[0] = Convert_AtoD();
        
        this.pot_bytes[(int)(2*i)] = this.spidata[1];
        this.pot_bytes[(int)((2*i)+1)] = this.spidata[2];
        
        // Next obtain tachometer data        
        this.spidata[0] = (byte)0x89;
        this.spidata[1] = (byte)0x00;
        this.spidata[2] = (byte)0x00;
        
        // Transmits ADC command and receives data into spidata[1] and spidata[2]
        spi_LTC.xmit(this.spidata, 0, this.spidata.length);   
        
        // Converts the 2 bytes into an integer value
        this.ADC_bytecode = (((this.spidata[1]&0x7F)<<5)|((this.spidata[2]&0xFC)>>>2));    
        this.sys_out[1] = Convert_AtoD();
        //System.out.println(this.sys_out[0]);
    }   

    /* Sends float voltage to DAC */
    public void DAC_send(float voltage, boolean motor_or_PM) {
    	if (motor_or_PM) {
    		this.spidata_DAC = Convert_DtoA(voltage, true);               
    		spi_MAX.xmitA(this.spidata_DAC, 0, this.spidata_DAC.length);      // Transmitting via I2C port pin 3
    	} else {
    		this.spidata_DAC = Convert_DtoA(voltage, false);               
    		spi_MAX.xmitA(this.spidata_DAC, 0, this.spidata_DAC.length);      // Transmitting via I2C port pin 3   		
    	}
    }

    public void PowerModule(boolean on_off) {
    	if (on_off) {
    		DAC_send((float)5,false);
    	} else {
    		DAC_send((float)-5,false);
    	}
    }
    
    /* Proportional-Derivative Control algorithm */
    public void PD_control(float command, float kp, float kd) {
        //float error = (float)0.0;
        //float derror = (float)0.0;
                
        for (this.i = 0; this.i < this.N; this.i++) {            
            ADC_get();
            
            //error = (float)(kp*((3.14/180.0)*command-0.64*this.sys_out[0]));
            //derror = (float)((-1.0)*(kd*this.sys_out[1]));
            //DAC_send(error+derror);            
            // I have commented the above 3 lines to save on computations for DC motor control 
            DAC_send((float)(kp*((0.01745329252)*command-0.64*this.sys_out[0]))+(float)(-0.212)+(float)((-kd*this.sys_out[1])), true);
        }
    }
    
    public void DC_run() {
        //this.DAC_send((float)2.0);
        PD_control(this.command, this.kp, this.kd); // Executes the PD controller
    }
}