import java.io.*;
import java.net.*;
import com.dalsemi.system.BitPort;
import com.dalsemi.system.TINIOS;

class TINIThread extends Thread {
    
    Socket s;
    DC_motor atw;
    
    short command;
    float kp;
    float kd;
    
    int k = 0;
    static byte[] N = new byte[2];
    byte[] iterations = new byte[2];
    byte[] temp = new byte[2];
    byte[] b = new byte[16];
    byte[] spidata = new byte[22];
    short num_iterations = 1;
    int c;
    short value;
    
    InputStream  in   = null;           // Internet-based input stream
    OutputStream out  = null;           // Internet-based output stream
    
    /** Constructor **/
    public TINIThread(Socket s, DC_motor atw) throws IOException { 
        this.s = s;
        this.atw = atw;
    }
    
    

    /* Converts a short number to a byte array */
    byte[] ShortToByteArray(short value) {
        this.N[0] = (byte)((value & 0xFF00)>>>8);
        this.N[1] = (byte)((value & 0x00FF));        
        return this.N;
    }
    
    /* Converts a byte array to a short number */
    short ByteArrayToShort(byte[] N) {
        this.value = (short)(((N[0]<<8)&0xFF00) | (N[1]&0x00FF));
        return value;        
    }
    
    /* Updates the DC motor control parameters using data obtained from Internet */
    public void update_parameters(byte[] getByteArray, DC_motor atw) {        
        this.temp[0] = getByteArray[0];
        this.temp[1] = getByteArray[1];
        this.command = ByteArrayToShort(temp);
        //System.out.println(this.command);
        
        this.temp[0] = getByteArray[2];
        this.temp[1] = getByteArray[3];
        this.kp = (float)(ByteArrayToShort(this.temp)/1000.0);
        //System.out.println(this.kp);

        this.temp[0] = getByteArray[4];
        this.temp[1] = getByteArray[5];
        this.kd = (float)(ByteArrayToShort(this.temp)/1000.0);
        //System.out.println(this.kd);
        atw.command = this.command;
        atw.kp = this.kp;
        atw.kd = this.kd;
    }
    
    
    /* TINI receives data until connection is closed by client */
    public void run() {
        try { 
            this.in  = this.s.getInputStream();
            this.out = this.s.getOutputStream();
            
            this.iterations = ShortToByteArray(this.num_iterations);
            
            
            while ((this.c = this.in.read(this.b)) > 0) {   // While data can not be read from input stream
                update_parameters(this.b, this.atw);    // Updates command, Kp, Kd parameters
                
                this.atw.DC_run();                      // starts the DC motor experiment
                
                this.spidata[0] = this.iterations[0];   // Saves the sample number 
                this.spidata[1] = this.iterations[1];
                
                // Save the potentiometer data array
                for (this.k = 0; this.k < 20; this.k++) {
                    this.spidata[k+2] = this.atw.pot_bytes[k];
                }
               
                // Outputs the data array
                this.out.write(this.spidata, 0, this.spidata.length);
                this.num_iterations++;
                this.iterations = ShortToByteArray(this.num_iterations);
            }            
        } catch (IOException ioe) {}
        
        // Closes all streams and sockets
        finally {
            try {
                this.in.close();
                this.out.close();
                this.s.close();
                
                this.in = null;
                this.out = null;
            } catch (IOException i) {}
        } // end of finally
    } // end of run
} // end of class
