import com.dalsemi.system.BitPort;
import com.dalsemi.system.TINIOS;

import com.dalsemi.tininet.*;
import java.net.*;
import java.io.*;

class DC_motor_control {
    static final int ECHO_PORT = 7;

    public static void main(String[] args) throws IOException {
        short t1 = (short)0.0;
        float kp = (float)0.0;
        float kd = (float)0.0;
        int N = 10;  // 10 iterations of PD control
        int N2 = 60; // 10 second Socket timeout
        TINIThread socket_thread; 
        //BitPort bp;
        
        DC_motor atw = new DC_motor(t1, kp, kd, N);     // Defines new DC_motor object atw
        ServerSocket serverSocket = null;               // Defines a Server Socket
        Socket s = null;                                // Defines a normal socket for data communication
                
        try {
            serverSocket = new ServerSocket(ECHO_PORT);
        } catch(Exception e){}
        
        try {
            //serverSocket.setSoTimeout(N2*1000);
            serverSocket.setSoTimeout(N2*100);
        } catch(SocketException e){}
        
        
        /*if (TINIOS.getCPU() == TINIOS.DS80C390) {
            bp = new BitPort(BitPort.Port1Bit0);
        } else {
            bp = new BitPort(BitPort.Port1Bit0);
        }*/
        
        
        //bp.clear();                     // Turns off the Power Amp
        
        //atw.DAC_send((float)-0.2);      // Makes sure no voltage is going to motor
        atw.kp = (float)0.6;
        atw.kd = (float)-0.2;
        atw.DC_run();
            

        // Main connection loop. This loop will infinitely continue looking for a socket acceptance
        while (true) {
            try { 
                s = serverSocket.accept();          // Accepts a client connection
                
                //System.out.println("Accepted socket connection...");
                //atw.DAC_send((float)-0.2);
                atw.kp = (float)0.6;
                atw.kd = (float)-0.2;
                atw.DC_run();
                
                try {
                    Thread.sleep(100);
                } catch (InterruptedException ie) {} 
                
                //bp.set();               // Turns on the Power Amp
                atw.PowerModule(true);
                socket_thread = new TINIThread(s, atw);         // Initializes TINIThread
                System.out.println("Accepted socket connection...");
                
                
                socket_thread.start();
                try {
                    socket_thread.join();
                } catch(java.lang.InterruptedException e) {}

            } catch(java.io.InterruptedIOException e) {      
                System.out.println("Waiting for a connection...");
                
                //atw.DAC_send((float)-0.2);           // outputs Default DAC voltage
                atw.kp = (float)0.6;
                atw.kd = (float)-0.2;
                atw.DC_run();
                atw.PowerModule(false);
                //bp.clear();             // Turns off the Power Amp
                socket_thread = null;
                System.gc();
            } // end of catch
        } // end of while               
    } // end of main
} // end of class